(unless (boundp '*need-second-listener*) (setf *need-second-listener* t))

(defproto vista-listener-proto '(showing ) () listener-proto)


(defun make-listener (&key (in nil used?) (menubar t) (copyright t) (toolwindow nil))
"Args: &KEY (in nil used?) (menubar t) (copyright t) (toolwindow nil)"
  (let* ((prev-container *active-container*)
         (calc-container)
         (new-listener)) (listeners)
    (setf calc-container 
          (cond
            ((and (not in) (not used?))
             (container :localmenu t :toolwindow toolwindow
                        :title "Listener"
                        :size (list 490 (- (second (screen-size)) 126))))
            ((and (not in) used?) (disable-container))
            (t (enable-container in))))
    (setf new-listener  (send vista-listener-proto :new :location '(4 24) 
                              :print nil
                              :SIZE (list 490 (- (second (screen-size)) 126))))
    (when menubar (add-menubar))
    (when copyright (vista-copyright))
    (send new-listener :location 0 0) 
    (send new-listener :size 490 (- (second (screen-size)) 126))
    (send new-listener :add-slot 'container)
    (send new-listener :no-move nil)
    (defmeth new-listener :container (&optional (value nil set))
      (if set (setf (slot-value  'container) value))
      (slot-value 'container))
    (send new-listener :container calc-container)
    (send calc-container :add-slot 'showing)
    (defmeth calc-container :showing (&optional (value nil set))
      (if set (setf (slot-value  'showing) value))
      (slot-value 'showing))
    (defmeth calc-container :maximized? (&optional (value nil set))
      (if set (setf (slot-value  'maximized?) value))
      (slot-value 'maximized?))
    (send new-listener :add-slot 'maximized?)
    (defmeth new-listener :maximized? (&optional (value nil set))
      (if set (setf (slot-value  'maximized?) value))
      (slot-value 'maximized?))
    (defmeth calc-container :close ()
      (send self :showing nil)
      (send self :hide-window)
      (setf *num-listener-lines* 4)
      (refresh))
    (defmeth calc-container :resize ()
      (call-next-method)
      (apply #'send new-listener :size (- (send self :size) '(0 16))))
    (if copyright
        (vista-copyright)
        new-listener)
    new-listener)); didn't return object


(setf *listener-window* nil)

(defun listener-window ()
  (if *listener-window*
      (progn
       (unless (send *listener-window* :showing)
               (setf *num-listener-lines* -2)
               (refresh))
       (send *listener-window* :show-window)
       (send *listener-window* :top-most t)
       (send *listener-window* :top-most nil)
       )
      (progn
       (setf *num-listener-lines* -2)
       (refresh)
       (setf *listener-window* (make-listener))
       ))
  *listener-window*)


(defun user-listener (&key (viva t))
  (if *user-listener*
      (progn
       (unless (send *user-listener* :showing)
               (setf *num-listener-lines* -2)
               (refresh))
       (send *user-listener* :show-window)
       (send *user-listener* :top-most t)
       (send *user-listener* :top-most nil))
      (progn
       (setf *num-listener-lines* -2)
       (refresh)
       (setf *user-listener* (make-listener))
       (when viva (print-viva-listener-help))
       )))
#|
 | CHANGED HERE
 |#

;new fwy 10122000
(defun num-listener-lines (&optional (height (second (send *listener* :size))))
  (1+ (floor (/ height (+ (send display-window-proto2 :text-ascent)
                      (send display-window-proto2 :text-descent))))))

(defun num-listener-lines () *num-listener-lines*)

(defmeth listener-proto :maximize ()
  (send self :frame-location 0 0)
  (apply #'send self :size 
         (+ '(-8 -46) (send *desktop-container* :size))))

(defun maximize-listener ()
  (remake-desktop-menu-items 2 *default-workmap-proportion*))


#|
 | TO HERE
 |#

(defun show-desktop-listener ()
  (setf *num-listener-lines* 0)
  (send *desktop-listener-item* :title "Show DeskTop Listener")
  (send *desktop-container* :resize))

(defun hide-desktop-listener ()
  (send *desktop-listener-item* :title "Hide DeskTop Listener")
  (send *desktop-container* :front-window)
  (send *desktop-container* :resize))

(defun desktop-listener ()
  (if (= *num-listener-lines* 4)
      (show-desktop-listener)
      (hide-desktop-listener)))

(defun default-listener ()
  (hide-desktop-listener)
  (apply #'send *listener* :size (floor (* 2/3 (screen-size))))
  (send *listener* :location 40 40)
  (hide-desktop-listener)
  )

(defun user-listener ())


(defun manipulate-variables () 
  (make-listener)
  (apply #'format t "~2%~a~%~a~%"(viva-copyright))
  (terpri)
  (format t "$Data: ")
  (print-$data)
  (terpri)
  (format t "$Vars: ")
  (print-$vars)
  (terpri)
  (format t "$:     ~a~%"$)
  (terpri)
  (viva))


(defun print-$vars (&optional (dob $))
    (map-elements #'format t "~a " (print-$variable-names dob)))

(defun print-$variable-names (dob)
  (when dob
        (setcd dob)
        (map-elements #'string-capitalize $vars)))

(defun print-$data ()
  (map-elements #'format t "~a " (print-$data-set-names)))

(defun print-$data-set-names ()
(mapcar #'(lambda (data)
              (string-capitalize (format nil "~a" data)))
          $data))

;(if *need-second-listener* (listeners :micro t))